@echo off
setlocal enabledelayedexpansion
echo __         ______     ______     __     __  __     __  __
echo/\ \       /\  __ \   /\  ___\   /\ \   /\_\_\_\   /\ \_\ \
echo\ \ \____  \ \ \/\ \  \ \ \__ \  \ \ \  \/_/\_\/_  \ \____ \
echo \ \_____\  \ \_____\  \ \_____\  \ \_\   /\_\/\_\  \/\_____\
echo  \/_____/   \/_____/   \/_____/   \/_/   \/_/\/_/   \/_____/

set downloader=curl -# -A "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64)" --ssl-no-revoke
set ldir=%appdata%\Logixy
set zipfile=bellsoft-jre.zip
set max_retries=3

if NOT EXIST %ldir% (
    mkdir %ldir%
)
cd %ldir%

if NOT EXIST %ldir% mkdir %ldir%
cd %ldir%

if NOT EXIST jre-21.0.4-full/bin/java.exe (
    echo Downloading Liberica JRE... %PROCESSOR_ARCHITECTURE%
	
	set /a tries=0
    :download_retry
    if EXIST %zipfile% del %zipfile%
    if "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
        set url_github=https://github.com/bell-sw/Liberica/releases/download/21.0.4%%2B9/bellsoft-jre21.0.4+9-windows-amd64-full.zip
        set url_mirror=https://logixy.net/launcher/java/bellsoft-jre21.0.4%%2B9-windows-amd64-full.zip
    ) 
	if "%PROCESSOR_ARCHITECTURE%"=="ARM64" (
        set url_github=https://github.com/bell-sw/Liberica/releases/download/21.0.4%%2B9/bellsoft-jre21.0.4+9-windows-aarch64-full.zip
        set url_mirror=https://logixy.net/launcher/java/bellsoft-jre21.0.4%%2B9-windows-aarch64-full.zip
    ) 
	if "%PROCESSOR_ARCHITECTURE%"=="X86" (
        set url_github=https://github.com/bell-sw/Liberica/releases/download/21.0.4%%2B9/bellsoft-jre21.0.4+9-windows-i586-full.zip
        set url_mirror=https://logixy.net/launcher/java/bellsoft-jre21.0.4%%2B9-windows-i586-full.zip
    ) 
	if "!url_github!"=="" (
        echo Unsupported architecture: %PROCESSOR_ARCHITECTURE%
        goto end
    )
	
	rem Last try is url_mirror anyway
	if !tries! GEQ %max_retries% (
		set url_github=!url_mirror!
	)

    rem Пытаемся скачать с GitHub
    echo %downloader% -L "!url_github!" -o %zipfile%
    if NOT EXIST %zipfile% (
        echo Download from GitHub failed, trying mirror...
        %downloader% -L "!url_mirror!" -o %zipfile%
    )

    if NOT EXIST %zipfile% (
        echo Failed to download JRE from both sources!
    )

    tar -xf %zipfile%
	if ERRORLEVEL 1 (
        echo Extraction failed, retrying download and extraction...
        set /a tries+=1
        if !tries! GTR %max_retries% (
            echo Maximum retries reached.
			goto end
        )
        goto download_retry
    )
    del %zipfile%
)

if NOT EXIST Logixy.jar (
echo Downloading Logixy launcher...
%downloader% -L "https://logixy.net/launcher/Logixy.jar" -o Logixy.jar
)
if NOT EXIST favicon.ico (
%downloader% -L "https://logixy.net/launcher/windows/favicon.ico" -o favicon.ico
)

if "%1"=="start" (
:start_game
echo Starting the game...
"jre-21.0.4-full/bin/java.exe" -jar Logixy.jar
goto end
)

set dsc=%TEMP%\CreateShortcut.vbs
echo Set objShell = CreateObject("WScript.Shell") > %dsc%
echo Set objLink = objShell.CreateShortcut("%ldir%\Logixy.lnk") >> %dsc%
echo objLink.Description = "Start launcher" >> %dsc%
echo objLink.TargetPath = "%ldir%\jre-21.0.4-full\bin\java.exe" >> %dsc%
echo objLink.Arguments = "-jar %ldir%\Logixy.jar" >> %dsc%
echo objLink.IconLocation = "%ldir%\favicon.ico" >> %dsc%
echo objLink.Save >>%dsc%
cscript %dsc%
del %dsc%

choice /C YN /M "Create desktop shotrcut? "
if ERRORLEVEL 2 goto end_step1
copy "%ldir%\Logixy.lnk" "%USERPROFILE%\Desktop\Logixy.lnk"
:end_step1

choice /C YN /M "Create start menu shotrcut? "
if ERRORLEVEL 2 goto end_step2
copy "%ldir%\Logixy.lnk" "%AppData%\Microsoft\Windows\Start Menu\Programs\Logixy.lnk"
:end_step2

choice /C YN /M "Start the game? "
if ERRORLEVEL 2 goto end
goto start_game

:end
